PROGRAM_FILES_X86_VARIABLE = '%ProgramFiles(x86)%';
PROGRAM_FILES_VARIABLE = '%ProgramFiles%';
PUBLIC_DOCUMENTS_VARIABLE = '%PUBLIC%\\Documents';
CSS_DIR_PATH_PREFIX = '\\Motorola\\CSS\\A';
CSS_WITHOUT_RELEASE_DIR_PATH_PREFIX = '\\Motorola\\CSS\\CSS';
SWDL_WITHOUT_RELEASE_DIR_PATH_PREFIX = '\\Motorola\\SWDL';
TEMP_DIR_NAME = '\\tmp';
SWDL_TMP_PATH = '\\swdl\\tmp';

function getProgramFilesX86Path() {
	var fileSystemObject = new ActiveXObject("Scripting.FileSystemObject");
	var shell = new ActiveXObject("Wscript.Shell");
	path = shell.ExpandEnvironmentStrings(PROGRAM_FILES_X86_VARIABLE);
	if(!fileSystemObject.FolderExists(path)) {
		path = shell.ExpandEnvironmentStrings(PROGRAM_FILES_VARIABLE);
	}
	return path;
}

function getPublicDocumentsPath() {
	var shell = new ActiveXObject("Wscript.Shell");
	return shell.ExpandEnvironmentStrings(PUBLIC_DOCUMENTS_VARIABLE);
}

function getCSSPath(release) {
	return getPublicDocumentsPath() + CSS_DIR_PATH_PREFIX + release;
}

function getCSSPathWithoutRelease() {
	return getPublicDocumentsPath() + CSS_WITHOUT_RELEASE_DIR_PATH_PREFIX;
}

function getTmpDir(release) {
	return getCSSPath(release) + TEMP_DIR_NAME;
}

function getTmpDirForCSSWithoutRelease() {
	return getCSSPathWithoutRelease() + TEMP_DIR_NAME;
}

function getInstallationPath(release) {
	return getProgramFilesX86Path() + CSS_DIR_PATH_PREFIX + release;
}

function getSWDLTmpPath(release) {
	return getCSSPath(release) + SWDL_TMP_PATH;
}

function getSWDLTmpPathWithoutRelease() {
	return getPublicDocumentsPath() + SWDL_WITHOUT_RELEASE_DIR_PATH_PREFIX + TEMP_DIR_NAME;
}

function log(path, message) {
	var fileSystemObject  = new ActiveXObject("Scripting.FileSystemObject"); 
	var file = fileSystemObject.OpenTextFile(path, 8, true); 
	file.WriteLine(new Date() + '\t' + message); 
	file.Close(); 
}